using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class Sign_in_form : System.Web.UI.Page
{
    protected void cmdLogin_Click(object sender, System.EventArgs e)
    {

        // This code will get executed when the "Sign in" button is clicked and the first thing that is
        // done is to check if the username and password corresponds to a user in the "Users" table.
        // We are sending the username and password to the "ValidateUser" function in the If-statement
        // and will then return an answer from this function, se this function after this subroutine.

        if (ValidateUser(LoginUserName.Text, LoginUserPass.Text) == true)
        {
            // We declare three variables that will be used to create a cookie for the signed in user. A ticket
            // with information, a string that should include the encrypted ticket and a HttpCookie.
            FormsAuthenticationTicket ticket = default(FormsAuthenticationTicket);
            string cookie = null;
            HttpCookie httpCookie = default(HttpCookie);

            // The FormsAuthenticationTicket is filled with data for version, name, issue date,
            // expiration date, if the cookie are persistent or not, user data and cookie path.
            ticket = new FormsAuthenticationTicket(1, LoginUserName.Text, DateTime.Now, DateTime.Now.AddMinutes(100), chkPersistCookie.Checked, HiddenAdminValue.Value, "MyPage");

            // The cookie is set to the encrypted ticket
            cookie = FormsAuthentication.Encrypt(ticket);

            // The httpCookie gets a name and the value from the cookie
            httpCookie = new HttpCookie(FormsAuthentication.FormsCookieName, cookie);

            // We set the expiration date for the httpCookie if the checkbox of chkPersistCookie are checked.
            // if we dont set the expiration date for the HttpCookie then it will be deleted when the browser
            // is shut down.
            if (chkPersistCookie.Checked == true)
            {
                httpCookie.Expires = ticket.Expiration;          
            }

            // Set the path for the HttpCookie.
            httpCookie.Path = FormsAuthentication.FormsCookiePath;  

            // Add the HttpCookie.
            Response.Cookies.Add(httpCookie);

            // The user is redirected to "Protected-page.aspx"
            Response.Redirect("Protected-page.aspx", true);
        }
        else
        {
            lblMessage.Text = "* Incorrect password or e-mail";
        }
    }

    private bool ValidateUser(string userName, string passWord)
    {

        // This is a check that is done for the entered user name, i has to be between 1 and 80
        // characters. If this check false this function will return a "False" statement and the
        // code below will not be executed. The "|" sign means Or.

        if ((userName.Length == 0) | (userName.Length > 80))
        {
            System.Diagnostics.Trace.WriteLine("[ValidateUser] Input validation of userName failed.");
            
            return false;
        }

        // This is a check that is done for the entered password, i has to be between 1 and 25
        // characters. If this check false this function will return a "False" statement and the
        // code below will not be executed. The "|" sign means Or.

        if ((passWord.Length == 0) | (passWord.Length > 25))
        {
            System.Diagnostics.Trace.WriteLine("[ValidateUser] Input validation of passWord failed.");
            
            return false;
        }

        // We receive the userName and passWord as variables when this function is called and we 
        // create the variable "lookupPassword" as a string to store the password that is selected from
        // the database. The hidden field "HiddenAdminValue" that should store a bit value that indicate
        // if the user is Admin or not have it's value set to Blank at the start. The passWord that is
        // passed to this function is encrypted with SHA1 because the password that is stored in the
        // table "Users" are encrypted with SHA1 and therefore have to do this encryption to compare 
        // the entered password with the stored password in the database.

        string lookupPassword = null;
        HiddenAdminValue.Value = string.Empty;
        string passwordHash = FormsAuthentication.HashPasswordForStoringInConfigFile(passWord, "SHA1");

        // This code is used to select the password and admin value from the "Users" table according to
        // the supplied username in the "sign in form".

        string ConnString = ConfigurationManager.ConnectionStrings["ConnectionString"].ToString();
        string SelectUser = "SELECT Password, Admin FROM Users WHERE UserName = @UserName";
   
        // The using block is used to call dispose (close) automatically even if there are an exception.
        using (SqlConnection cn = new SqlConnection(ConnString))
        {
            // Create a SqlCommand.
            SqlCommand cmd = new SqlCommand(SelectUser, cn);

            // Create a SqlDataReader.
            SqlDataReader reader = null;

            // Add parameters.
            cmd.Parameters.AddWithValue("@UserName", LoginUserName.Text);

            try
            {
                // Open the SqlConnection.
                cn.Open();

                // We use SqlDataReader and just want to select one single row. The Admin value are
                // supplied to the hidden field "HiddenAdminValue" and the Password are supplied to the
                // "lookupPassword" string.

                reader = cmd.ExecuteReader(CommandBehavior.SingleRow);

                while (reader.Read())
                {
                    HiddenAdminValue.Value = reader["Admin"].ToString();
                    lookupPassword = reader["Password"].ToString();
                }

            }
            catch (Exception ex)
            {
                System.Diagnostics.Trace.WriteLine("[ValidateUser] Exception " + ex.Message);
            }
            finally
            {
                // Dispose the SqlCommand.
                cmd.Dispose();

                // Close the SqlDataReader.
                if (reader != null)
                    reader.Close();
            }
        }

        // If no password is found this function will return false.
        if (lookupPassword == null)
        {
            // You could write failed login attempts here to the event log for additional security.
            return false;
        }

        // Compare lookupPassword and passwordHash by using a case-sensitive comparison.
        return (string.Compare(lookupPassword, passwordHash, false) == 0);
    }
}
